/*
 * FieldCacheManager.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */

package adams.gui.selection;

import java.io.Serializable;
import java.util.Hashtable;

import adams.db.FieldProvider;

/**
 * Manages the field caches.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 4047 $
 */
public abstract class AbstractFieldCacheManager
  implements Serializable {

  /** for serialization. */
  private static final long serialVersionUID = -6836635614654765458L;

  /** the cache items to manage. */
  protected Hashtable<String,AbstractFieldCacheItem> m_Items;

  /**
   * Initializes manager.
   */
  public AbstractFieldCacheManager() {
    m_Items = new Hashtable<String,AbstractFieldCacheItem>();
  }

  /**
   * Clears the cache.
   */
  public void clear() {
    m_Items.clear();
  }

  /**
   * Creates a new cache item.
   *
   * @param provider	the provider for which to create a new item
   */
  protected abstract AbstractFieldCacheItem newFieldCacheItem(FieldProvider provider);

  /**
   * Retrieves the cache item for the specified database connection,
   * creates it if necessary.
   *
   * @param provider	the field provider
   * @return		the cache item
   */
  public AbstractFieldCacheItem get(FieldProvider provider) {
    String	key;

    key = provider.getDatabaseConnection().getURL() + "\t" + provider.getDatabaseConnection().getUser();
    if (!m_Items.containsKey(key))
      m_Items.put(key, newFieldCacheItem(provider));

    return m_Items.get(key);
  }
}