/*
 * ReportContainerList.java
 * Copyright (C) 2010 University of Waikato, Hamilton, New Zealand
 */

package adams.gui.visualization.report;

import adams.gui.visualization.container.ContainerList;

/**
 * A class encapsulating containers tailored for reports.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 1606 $
 */
public class ReportContainerList
  extends ContainerList<ReportContainerManager, ReportContainer> {

  /** for serialization. */
  private static final long serialVersionUID = -1049275455980966385L;

  /**
   * Creates a new model.
   *
   * @param manager	the manager to base the model on
   * @return		the model
   */
  protected ReportContainerModel createModel(ReportContainerManager manager) {
    return new ReportContainerModel(manager);
  }
}
