/**
 * MultiConversionTest.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */

package adams.data.conversion;

import adams.core.base.BaseText;
import adams.data.conversion.AbstractConversion;
import adams.data.conversion.MultiConversion;
import adams.test.TmpFile;

import java.io.File;

/**
 * Tests the MultiConversion conversion.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 2887 $
 */
public class MultiConversionTest
  extends AbstractConversionTestCase {

  /**
   * Constructs the test case. Called by subclasses.
   *
   * @param name 	the name of the test
   */
  public MultiConversionTest(String name) {
    super(name);
  }

  /**
   * Returns the input data to use in the regression test.
   *
   * @return		the objects
   */
  protected Object[] getRegressionInput() {
    return new Object[]{
	new Double(1.345),
	new Double(7.45),
	new Double(1.67E-45)
    };
  }

  /**
   * Returns the setups to use in the regression test.
   *
   * @return		the setups
   */
  protected AbstractConversion[] getRegressionSetups() {
    MultiConversion[]	result;

    result = new MultiConversion[3];
    result[0] = new MultiConversion();
    result[1] = new MultiConversion();
    result[1].setSubConversions(new AbstractConversion[]{
	new AnyToString()
    });
    result[2] = new MultiConversion();
    result[2].setSubConversions(new AbstractConversion[]{
	new DoubleToString(),
	new LowerCase()
    });

    return result;
  }

  /**
   * Returns the ignored line indices to use in the regression test.
   *
   * @return		the setups
   */
  protected int[] getRegressionIgnoredLineIndices() {
    return new int[0];
  }
}
