/*
 * UpdateVariableTest.java
 * Copyright (C) 2010 University of Waikato, Hamilton, New Zealand
 */

package adams.flow.template;

import junit.framework.Test;
import junit.framework.TestSuite;
import adams.core.VariableName;
import adams.env.Environment;
import adams.test.TmpFile;

/**
 * Tests the UpdateVariable template.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3209 $
 */
public class UpdateVariableTest
  extends AbstractActorTemplateTestCase {

  /**
   * Initializes the test.
   *
   * @param name	the name of the test
   */
  public UpdateVariableTest(String name) {
    super(name);
  }

  /**
   * Returns the setups to use in the regression test.
   *
   * @return		the setups
   */
  protected AbstractActorTemplate[] getRegressionSetups() {
    UpdateVariable[]	result;

    result = new UpdateVariable[1];

    result[0] = new UpdateVariable();
    result[0].setVariableName(new VariableName("blah"));

    return result;
  }

  /**
   * Returns a test suite.
   *
   * @return		the test suite
   */
  public static Test suite() {
    return new TestSuite(UpdateVariableTest.class);
  }

  /**
   * Runs the test from commandline.
   *
   * @param args	ignored
   */
  public static void main(String[] args) {
    Environment.setEnvironmentClass(Environment.class);
    runTest(suite());
  }
}
