/*
 * Decompiled with CFR 0.152.
 */
package adams.core;

import adams.core.DateFormat;
import adams.core.DateUtils;
import adams.core.UtilsTest;
import adams.env.Environment;
import adams.test.AdamsTestCase;
import java.util.Date;
import junit.framework.Test;
import junit.framework.TestSuite;

public class DateUtilsTest
extends AdamsTestCase {
    public DateUtilsTest(String name) {
        super(name);
    }

    public void testTimestampFormatter() {
        DateUtilsTest.assertEquals((String)"date format differs", (String)"yyyy-MM-dd HH:mm:ss", (String)DateUtils.getTimestampFormatter().toPattern());
    }

    public void testIsValid() {
        String pattern = "dd-MM-yyyy";
        DateUtilsTest.assertTrue((String)("pattern '" + pattern + "' should be valid"), (boolean)DateUtils.isValid((String)pattern));
        pattern = "dd-MM-YYYY";
        DateUtilsTest.assertFalse((String)("pattern '" + pattern + "' should not be valid"), (boolean)DateUtils.isValid((String)pattern));
    }

    public void testEarlier() {
        DateFormat dformat = new DateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = dformat.parse("2012-02-07 13:51:00");
        Date earlier = dformat.parse("2012-02-07 11:51:00");
        DateUtilsTest.assertEquals((String)"dates differ (hours)", (Object)date, (Object)DateUtils.earlier((Date)date, (int)10, (int)2));
        earlier = dformat.parse("2012-02-05 13:51:00");
        DateUtilsTest.assertEquals((String)"dates differ (days)", (Object)date, (Object)DateUtils.earlier((Date)date, (int)10, (int)48));
        earlier = dformat.parse("2011-12-07 13:51:00");
        DateUtilsTest.assertEquals((String)"dates differ (months)", (Object)date, (Object)DateUtils.earlier((Date)date, (int)2, (int)2));
        earlier = dformat.parse("2010-02-07 13:51:00");
        DateUtilsTest.assertEquals((String)"dates differ (years)", (Object)date, (Object)DateUtils.earlier((Date)date, (int)1, (int)2));
    }

    public void testLater() {
        DateFormat dformat = new DateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = dformat.parse("2012-02-07 13:51:00");
        Date later = dformat.parse("2012-02-07 15:51:00");
        DateUtilsTest.assertEquals((String)"dates differ (hours)", (Object)date, (Object)DateUtils.later((Date)date, (int)10, (int)2));
        later = dformat.parse("2012-02-09 13:51:00");
        DateUtilsTest.assertEquals((String)"dates differ (days)", (Object)date, (Object)DateUtils.later((Date)date, (int)10, (int)48));
        later = dformat.parse("2012-04-07 13:51:00");
        DateUtilsTest.assertEquals((String)"dates differ (months)", (Object)date, (Object)DateUtils.later((Date)date, (int)2, (int)2));
        later = dformat.parse("2014-02-07 13:51:00");
        DateUtilsTest.assertEquals((String)"dates differ (years)", (Object)date, (Object)DateUtils.later((Date)date, (int)1, (int)2));
    }

    public void testSet() {
        DateFormat dformat = new DateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = dformat.parse("2012-02-07 13:51:00");
        DateUtilsTest.assertNull((String)"should have been null (feburary has max 29 days)", (Object)DateUtils.set((Date)date, (int)5, (int)30));
        DateUtilsTest.assertNotNull((String)"should have been not null (hour can have 59 minutes)", (Object)DateUtils.set((Date)date, (int)12, (int)59));
    }

    public void testIsBefore() {
        DateFormat dformat = new DateFormat("yyyy-MM-dd HH:mm:ss");
        Date date1 = dformat.parse("2012-02-07 13:51:00");
        Date date2 = dformat.parse("2012-02-07 13:52:00");
        DateUtilsTest.assertTrue((String)"date should have been before", (boolean)DateUtils.isBefore((Date)date2, (Date)date1));
        DateUtilsTest.assertFalse((String)"date should not have been before", (boolean)DateUtils.isBefore((Date)date1, (Date)date2));
    }

    public void testIsAfter() {
        DateFormat dformat = new DateFormat("yyyy-MM-dd HH:mm:ss");
        Date date1 = dformat.parse("2012-02-07 13:51:00");
        Date date2 = dformat.parse("2012-02-07 13:52:00");
        DateUtilsTest.assertTrue((String)"date should have been afte", (boolean)DateUtils.isAfter((Date)date1, (Date)date2));
        DateUtilsTest.assertFalse((String)"date should not have been after", (boolean)DateUtils.isAfter((Date)date2, (Date)date1));
    }

    public static Test suite() {
        return new TestSuite(UtilsTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        DateUtilsTest.runTest(DateUtilsTest.suite());
    }
}

