/*
 * Decompiled with CFR 0.152.
 */
package adams.core.option;

import adams.core.Utils;
import adams.core.option.AbstractOption;
import adams.core.option.ArrayConsumer;
import adams.core.option.ArrayProducer;
import adams.core.option.OptionHandler;
import adams.core.option.OptionManager;
import adams.core.option.OptionUtils;
import adams.test.AdamsTestCase;
import java.io.Serializable;
import java.util.List;

public abstract class AbstractOptionTest
extends AdamsTestCase {
    protected OptionHandler m_OptionHandler;

    public AbstractOptionTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.m_OptionHandler = this.getOptionHandler();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        this.m_OptionHandler.cleanUpOptions();
        this.m_OptionHandler = null;
    }

    protected abstract OptionHandler getOptionHandler();

    public void testEmptyArray() {
        ArrayConsumer.setOptions((OptionHandler)this.m_OptionHandler, (String[])new String[0]);
    }

    public void testObtainingArray() {
        String[] options = ArrayProducer.getOptions((OptionHandler)this.m_OptionHandler);
        AbstractOptionTest.assertNotNull((String)"options array must not be null", (Object)options);
    }

    @Override
    public void testDefaultOptions() {
        String before = OptionUtils.getCommandLine((Object)this.m_OptionHandler);
        String[] options = ArrayProducer.getOptions((OptionHandler)this.m_OptionHandler);
        ArrayConsumer.setOptions((OptionHandler)this.m_OptionHandler, (String[])options);
        String after = OptionUtils.getCommandLine((Object)this.m_OptionHandler);
        AbstractOptionTest.assertEquals((String)"setting the current options must result in the same option string", (String)before, (String)after);
    }

    @Override
    public void testSerializable() {
        List options = this.m_OptionHandler.getOptionManager().getOptionsList();
        for (AbstractOption option : options) {
            AbstractOptionTest.assertNotNull((String)("Not serializable: " + option), (Object)Utils.deepCopy((Object)option));
        }
    }

    public static abstract class AbstractOptionClass
    implements OptionHandler,
    Serializable {
        private static final long serialVersionUID = 1455059869697429814L;
        protected OptionManager m_OptionManager;

        public AbstractOptionClass() {
            this.defineOptions();
            this.getOptionManager().setDefaults();
        }

        public void defineOptions() {
            this.m_OptionManager = new OptionManager((OptionHandler)this);
        }

        public OptionManager getOptionManager() {
            return this.m_OptionManager;
        }

        public void cleanUpOptions() {
            if (this.m_OptionManager != null) {
                this.m_OptionManager.cleanUp();
                this.m_OptionManager = null;
            }
        }

        public void destroy() {
            this.cleanUpOptions();
        }
    }
}

