/*
 * Decompiled with CFR 0.152.
 */
package adams.core.option;

import adams.core.option.AbstractOptionTest;
import adams.core.option.ArrayConsumer;
import adams.core.option.ArrayProducer;
import adams.core.option.OptionHandler;
import adams.core.option.OptionUtils;
import adams.env.Environment;
import junit.framework.Test;
import junit.framework.TestSuite;

public class BooleanOptionTest
extends AbstractOptionTest {
    public BooleanOptionTest(String name) {
        super(name);
    }

    @Override
    protected OptionHandler getOptionHandler() {
        return new BooleanOptionClass();
    }

    public void testFlip() {
        ((BooleanOptionClass)this.m_OptionHandler).setBooleanPrim(true);
        String before = OptionUtils.getCommandLine((Object)this.m_OptionHandler);
        String[] options = ArrayProducer.getOptions((OptionHandler)this.m_OptionHandler);
        ArrayConsumer.setOptions((OptionHandler)this.m_OptionHandler, (String[])options);
        String after = OptionUtils.getCommandLine((Object)this.m_OptionHandler);
        BooleanOptionTest.assertEquals((String)"Commandline string should be the same", (String)before, (String)after);
    }

    public void testFlipInv() {
        ((BooleanOptionClass)this.m_OptionHandler).setBooleanPrimInv(false);
        String before = OptionUtils.getCommandLine((Object)this.m_OptionHandler);
        String[] options = ArrayProducer.getOptions((OptionHandler)this.m_OptionHandler);
        ArrayConsumer.setOptions((OptionHandler)this.m_OptionHandler, (String[])options);
        String after = OptionUtils.getCommandLine((Object)this.m_OptionHandler);
        BooleanOptionTest.assertEquals((String)"Commandline string should be the same", (String)before, (String)after);
    }

    public static Test suite() {
        return new TestSuite(BooleanOptionTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        BooleanOptionTest.runTest(BooleanOptionTest.suite());
    }

    public static class BooleanOptionClass
    extends AbstractOptionTest.AbstractOptionClass {
        private static final long serialVersionUID = -5064138646192507858L;
        protected boolean m_BooleanPrim;
        protected Boolean m_BooleanObj;
        protected boolean m_BooleanPrimInv;
        protected Boolean m_BooleanObjInv;

        @Override
        public void defineOptions() {
            super.defineOptions();
            this.m_OptionManager.add("boolean-prim", "booleanPrim", (Object)false);
            this.m_OptionManager.add("boolean-obj", "booleanObj", (Object)new Boolean(false));
            this.m_OptionManager.add("boolean-prim-inv", "booleanPrimInv", (Object)true);
            this.m_OptionManager.add("boolean-obj-inv", "booleanObjInv", (Object)new Boolean(true));
        }

        public void setBooleanPrim(boolean value) {
            this.m_BooleanPrim = value;
        }

        public boolean getBooleanPrim() {
            return this.m_BooleanPrim;
        }

        public String booleanPrimTipText() {
            return "booleanPrim";
        }

        public void setBooleanObj(Boolean value) {
            this.m_BooleanObj = value;
        }

        public Boolean getBooleanObj() {
            return this.m_BooleanObj;
        }

        public String booleanObjTipText() {
            return "booleanObj";
        }

        public void setBooleanPrimInv(boolean value) {
            this.m_BooleanPrimInv = value;
        }

        public boolean getBooleanPrimInv() {
            return this.m_BooleanPrimInv;
        }

        public String booleanPrimInvTipText() {
            return "booleanPrimInv";
        }

        public void setBooleanObjInv(Boolean value) {
            this.m_BooleanObjInv = value;
        }

        public Boolean getBooleanObjInv() {
            return this.m_BooleanObjInv;
        }

        public String booleanObjInvTipText() {
            return "booleanObjInv";
        }
    }
}

