/*
 * Decompiled with CFR 0.152.
 */
package adams.flow;

import adams.core.io.FileUtils;
import adams.core.option.AbstractOptionProducer;
import adams.core.option.ArrayProducer;
import adams.core.option.OptionHandler;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.gui.core.GUIHelper;
import adams.test.AbstractDatabaseTestCase;
import adams.test.AbstractTestHelper;
import adams.test.TestHelper;
import java.io.File;

public abstract class AbstractFlowTest
extends AbstractDatabaseTestCase {
    public static final String PROPERTY_DUMPFILE = "adams.test.flow.dump.file";
    public static final String PROPERTY_APPEND = "adams.test.flow.dump.append";
    public static final String PROPERTY_FORMAT = "adams.test.flow.dump.format";
    protected static boolean VERBOSE = false;
    protected AbstractActor m_Actor;

    public AbstractFlowTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.m_Actor = this.getActor();
        if (this.m_Actor instanceof Flow) {
            ((Flow)this.m_Actor).setErrorHandling(Flow.ErrorHandling.ACTORS_ALWAYS_STOP_ON_ERROR);
        }
    }

    @Override
    protected void tearDown() throws Exception {
        if (!this.m_Actor.isStopped()) {
            this.m_Actor.wrapUp();
            this.m_Actor.destroy();
        }
        this.m_Actor = null;
        super.tearDown();
    }

    public abstract AbstractActor getActor();

    protected int[] getRegressionIgnoredLineIndices() {
        return new int[0];
    }

    protected void performRegressionTest(File file) {
        this.performRegressionTest(new File[]{file});
    }

    protected void performRegressionTest(File[] files) {
        String result = this.m_Actor.setUp();
        AbstractFlowTest.assertNull((String)("setUp() not null: " + result), (Object)result);
        result = this.m_Actor.execute();
        AbstractFlowTest.assertNull((String)("execute() not null: " + result), (Object)result);
        result = this.m_Actor.getStopMessage();
        AbstractFlowTest.assertNull((String)("getStopMessage() not null: " + result), (Object)result);
        this.m_Actor.wrapUp();
        if (result == null) {
            String regression = this.m_Regression.compare(files, this.getRegressionIgnoredLineIndices());
            AbstractFlowTest.assertNull((String)("Output differs:\n" + regression), (Object)regression);
        }
    }

    @Override
    protected AbstractTestHelper newTestHelper() {
        return new TestHelper(this, "adams/flow/data");
    }

    protected String dumpActor(AbstractActor actor) {
        String format = System.getProperty(PROPERTY_FORMAT);
        ArrayProducer producer = null;
        if (format != null && format.length() >= 0) {
            try {
                producer = (AbstractOptionProducer)Class.forName(format).newInstance();
            }
            catch (Exception e) {
                System.err.println("Failed to instantiate option producer '" + format + "': " + e);
                producer = null;
            }
        }
        if (producer == null) {
            producer = new ArrayProducer();
        }
        producer.produce((OptionHandler)actor);
        return producer.toString();
    }

    public void testActor() {
        String filename = System.getProperty(PROPERTY_DUMPFILE);
        if (filename != null && filename.length() > 0 && !filename.startsWith("$")) {
            boolean append = Boolean.getBoolean(PROPERTY_APPEND);
            boolean written = FileUtils.writeToFile((String)filename, (Object)this.dumpActor(this.m_Actor), (boolean)append);
            if (written) {
                System.out.println(((Object)((Object)this)).getClass().getName() + ": flow " + (append ? "appended" : "saved") + " to " + filename);
            } else {
                System.out.println(((Object)((Object)this)).getClass().getName() + ": failed to " + (append ? "append" : "save") + " flow to " + filename);
            }
        }
        String result = this.m_Actor.setUp();
        AbstractFlowTest.assertNull((String)("setUp() not null: " + result), (Object)result);
        result = this.m_Actor.execute();
        AbstractFlowTest.assertNull((String)("execute() not null: " + result), (Object)result);
        result = this.m_Actor.getStopMessage();
        AbstractFlowTest.assertNull((String)("getStopMessage() not null: " + result), (Object)result);
        this.m_Actor.wrapUp();
    }

    public void testImage() {
        AbstractFlowTest.assertNotNull((String)"No icon found", (Object)GUIHelper.getIcon((Class)this.getTestedClass()));
    }
}

