/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.base.BaseString;
import adams.core.io.PlaceholderFile;
import adams.data.conversion.AbstractConversion;
import adams.data.conversion.DoubleToInt;
import adams.data.conversion.IntToString;
import adams.data.conversion.StringToDouble;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.sink.DumpFile;
import adams.flow.source.StringConstants;
import adams.flow.transformer.Convert;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;

public class ConvertTest
extends AbstractFlowTest {
    public ConvertTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
    }

    @Override
    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    @Override
    public AbstractActor getActor() {
        StringConstants sc = new StringConstants();
        sc.setStrings(new BaseString[]{new BaseString("1.0"), new BaseString("-1.0"), new BaseString("3.1415"), new BaseString("-1.4E3"), new BaseString("1.4E-3")});
        Convert ci1 = new Convert();
        ci1.setConversion((AbstractConversion)new StringToDouble());
        Convert ci2 = new Convert();
        ci2.setConversion((AbstractConversion)new DoubleToInt());
        Convert ci3 = new Convert();
        ci3.setConversion((AbstractConversion)new IntToString());
        DumpFile df = new DumpFile();
        df.setAppend(true);
        df.setOutputFile((PlaceholderFile)new TmpFile("dumpfile.txt"));
        Flow flow = new Flow();
        flow.setActors(new AbstractActor[]{sc, ci1, ci2, ci3, df});
        return flow;
    }

    public void testRegression() {
        this.performRegressionTest((File)((Object)new TmpFile("dumpfile.txt")));
    }

    public static Test suite() {
        return new TestSuite(ConvertTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        ConvertTest.runTest(ConvertTest.suite());
    }
}

