/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.data.conversion.AbstractConversion;

public class Minimum
extends AbstractConversion {
    private static final long serialVersionUID = 5942136303011254500L;
    protected double m_Minimum;

    @Override
    public String globalInfo() {
        return "If the numbers passing through fall below the defined minimum, the minimum is returned instead.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("minimum", "minimum", Double.MIN_VALUE);
    }

    public void setMinimum(double value) {
        this.m_Minimum = value;
        this.reset();
    }

    public double getMinimum() {
        return this.m_Minimum;
    }

    public String minimumTipText() {
        return "The guaranteed minimum of the numbers being output: if value being passed through falls below this threshold, this minimum is forwarded instead.";
    }

    @Override
    public Class accepts() {
        return Number.class;
    }

    @Override
    public Class generates() {
        return Double.class;
    }

    @Override
    protected Object doConvert() throws Exception {
        double value = ((Number)this.m_Input).doubleValue();
        if (value < this.m_Minimum) {
            return this.m_Minimum;
        }
        return value;
    }
}

