/**
 * Destroyable.java
 * Copyright (C) 2010 University of Waikato, Hamilton, New Zealand
 */
package adams.core;

/**
 * Interface for classes that need some further cleaning up that cannot be
 * done with the CleanUpHandler, as it is destructive.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 906 $
 * @see CleanUpHandler
 */
public interface Destroyable {

  /**
   * Frees up memory in a "destructive" non-reversible way.
   */
  public void destroy();
}
