/**
 * InetAddressHelper.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.core.net;

import java.net.InetAddress;

/**
 * Helper class for internet related stuff.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 2448 $
 */
public class InternetHelper {

  /**
   * Returns the IP address of the local host as string.
   *
   * @return		the IP address, null if not available
   */
  public static String getLocalHostIP() {
    String	result;

    try {
      result = InetAddress.getLocalHost().getHostAddress();
    }
    catch (Exception e) {
      // ignored
      result = null;
    }

    return result;
  }

  /**
   * Returns the machine name of the local host as string.
   *
   * @return		the machine name, null if not available
   */
  public static String getLocalHostName() {
    String	result;

    try {
      result = InetAddress.getLocalHost().getHostName();
    }
    catch (Exception e) {
      // ignored
      result = null;
    }

    return result;
  }
}
