/*
 * PassThrough.java
 * Copyright (C) 2008-2010 University of Waikato, Hamilton, New Zealand
 */

package adams.data.smoothing;

import adams.data.container.DataContainer;

/**
 <!-- globalinfo-start -->
 * A dummy smoother that just passes the data through.
 * <p/>
 <!-- globalinfo-end -->
 *
 <!-- options-start -->
 * Valid options are: <p/>
 *
 * <pre>-D (property: debug)
 *         If set to true, scheme may output additional info to the console.
 * </pre>
 *
 <!-- options-end -->
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 1259 $
 */
public class PassThrough
  extends AbstractSmoother {

  /** for serialization. */
  private static final long serialVersionUID = -3070023958174384004L;

  /**
   * Returns a string describing the object.
   *
   * @return 			a description suitable for displaying in the gui
   */
  public String globalInfo() {
    return "A dummy smoother that just passes the data through.";
  }

  /**
   * Performs the actual smoothing.
   *
   * @param data	the to smooth
   * @return		the smoothed data
   */
  protected DataContainer processData(DataContainer data) {
    return (DataContainer) data.getClone();
  }
}
