/**
 * DatabaseConnectionDefinition.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.env;

import adams.db.DatabaseConnection;

/**
 * Definition for the DatabaseConnection props file.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3507 $
 */
public class DatabaseConnectionDefinition
  extends AbstractPropertiesDefinition {

  /** for serialization. */
  private static final long serialVersionUID = 288970991741946271L;

  /** the key as constant. */
  public final static String KEY = "database connection - " + Project.NAME;

  /**
   * Returns the key this definition is for.
   *
   * @return		the key
   */
  public String getKey() {
    return KEY;
  }

  /**
   * Returns the properties file name (no path) this definition is for.
   *
   * @return		the key
   */
  public String getFile() {
    return DatabaseConnection.FILENAME;
  }

  /**
   * Returns an alternative extension to use besides the default one ("props").
   * Useful if distinguishing props files from different projects.
   *
   * @return		the alternative extension (without dot), null if none
   * 			available
   */
  public String getAlternativeExtension() {
    return Project.NAME;
  }

  /**
   * Updates the environment object with its definition for the props file
   * (whether to add/replace/etc the values).
   *
   * @param env		the environment object to update
   */
  public void update(AbstractEnvironment env) {
    add(env, Project.NAME + "/db", env.getDefaultHome(Project.NAME), new String[0]);
  }
}
