/**
 * AbstractTextDisplayPanel.java
 * Copyright (C) 2010 University of Waikato, Hamilton, New Zealand
 */
package adams.flow.sink;

/**
 * Ancestor for panels that can be created from tokens and supply the
 * underlying text.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 1010 $
 */
public abstract class AbstractTextDisplayPanel
  extends AbstractDisplayPanel
  implements TextSupplier {

  /** for serialization. */
  private static final long serialVersionUID = 4636549254255374437L;

  /**
   * Initializes the panel.
   *
   * @param name	the name of the panel
   */
  public AbstractTextDisplayPanel(String name) {
    super(name);
  }

  /**
   * Supplies the text.
   *
   * @return		the text, null if none available
   */
  public abstract String supplyText();
}
