/*
 * SetProperty.java
 * Copyright (C) 2009-2010 University of Waikato, Hamilton, New Zealand
 */

package adams.flow.standalone;

import adams.core.VariableName;
import adams.event.VariableChangeEvent;
import adams.event.VariableChangeEvent.Type;
import adams.event.VariableChangeListener;
import adams.flow.core.AbstractPropertyUpdater;

/**
 <!-- globalinfo-start -->
 * Sets the property of a global actor whenever the specified variable gets changed.<br/>
 * Note: this actor just sets the value, but performs no re-initialization or similar of the modified object.
 * <p/>
 <!-- globalinfo-end -->
 *
 <!-- flow-summary-start -->
 <!-- flow-summary-end -->
 *
 <!-- options-start -->
 * Valid options are: <p/>
 *
 * <pre>-D &lt;int&gt; (property: debugLevel)
 * &nbsp;&nbsp;&nbsp;The greater the number the more additional info the scheme may output to
 * &nbsp;&nbsp;&nbsp;the console (0 = off).
 * &nbsp;&nbsp;&nbsp;default: 0
 * &nbsp;&nbsp;&nbsp;minimum: 0
 * </pre>
 *
 * <pre>-name &lt;java.lang.String&gt; (property: name)
 * &nbsp;&nbsp;&nbsp;The name of the actor.
 * &nbsp;&nbsp;&nbsp;default: SetProperty
 * </pre>
 *
 * <pre>-annotation &lt;adams.core.base.BaseText&gt; (property: annotations)
 * &nbsp;&nbsp;&nbsp;The annotations to attach to this actor.
 * &nbsp;&nbsp;&nbsp;default:
 * </pre>
 *
 * <pre>-skip (property: skip)
 * &nbsp;&nbsp;&nbsp;If set to true, transformation is skipped and the input token is just forwarded
 * &nbsp;&nbsp;&nbsp;as it is.
 * </pre>
 *
 * <pre>-actor-name &lt;java.lang.String&gt; (property: actorName)
 * &nbsp;&nbsp;&nbsp;The name of the global actor to update the property for.
 * &nbsp;&nbsp;&nbsp;default: unknown
 * </pre>
 *
 * <pre>-property &lt;java.lang.String&gt; (property: property)
 * &nbsp;&nbsp;&nbsp;The property to update whenever the variable changes.
 * &nbsp;&nbsp;&nbsp;default:
 * </pre>
 *
 * <pre>-var-name &lt;java.lang.String&gt; (property: variableName)
 * &nbsp;&nbsp;&nbsp;The name of the variable to update.
 * &nbsp;&nbsp;&nbsp;default: variable
 * </pre>
 *
 <!-- options-end -->
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3328 $
 */
@Deprecated
public class SetProperty
  extends AbstractPropertyUpdater
  implements VariableChangeListener {

  /** for serialization. */
  private static final long serialVersionUID = 5397871140567615501L;

  /** the name of the variable. */
  protected VariableName m_VariableName;

  /**
   * Returns a string describing the object.
   *
   * @return 			a description suitable for displaying in the gui
   */
  public String globalInfo() {
    return
        "Sets the property of a global actor whenever the specified variable gets changed.\n"
      + "Note: this actor just sets the value, but performs no re-initialization "
      + "or similar of the modified object.";
  }

  /**
   * Adds options to the internal list of options.
   */
  public void defineOptions() {
    super.defineOptions();

    m_OptionManager.add(
	    "var-name", "variableName",
	    new VariableName());
  }

  /**
   * Sets the name of the variable to update.
   *
   * @param value	the name
   */
  public void setVariableName(VariableName value) {
    m_VariableName = value;
    reset();
  }

  /**
   * Returns the name of the variable to update.
   *
   * @return		the name
   */
  public VariableName getVariableName() {
    return m_VariableName;
  }

  /**
   * Returns the tip text for this property.
   *
   * @return 		tip text for this property suitable for
   * 			displaying in the GUI or for listing the options.
   */
  public String variableNameTipText() {
    return "The name of the variable to update.";
  }

  /**
   * Returns a quick info about the actor, which will be displayed in the GUI.
   *
   * @return		null if no info available, otherwise short string
   */
  public String getQuickInfo() {
    String	variable;
    String	result;

    variable = getOptionManager().getVariableForProperty("variableName");

    if (variable != null)
      result = variable;
    else
      result = m_VariableName.paddedValue();
    result += " -> " + m_ActorName + "/" + m_Property;

    return result;
  }

  /**
   * Gets triggered when a variable changed (added, modified, removed).
   *
   * @param e		the event
   */
  public void variableChanged(VariableChangeEvent e) {
    super.variableChanged(e);

    if (e.getName().equals(m_VariableName) && (e.getType() != Type.REMOVED) && (m_GlobalActor != null))
      updateProperty(getVariables().get(m_VariableName.getValue()));
  }

  /**
   * Initializes the item for flow execution.
   *
   * @return		null if everything is fine, otherwise error message
   */
  public String setUp() {
    String	result;

    result = super.setUp();

    if (result == null)
      getVariables().addVariableChangeListener(this);

    return result;
  }

  /**
   * Does nothing, as it waits for changes in variables only.
   *
   * @return		always null
   */
  protected String doExecute() {
    return null;
  }
}
