/**
 * TabVisibilityChangeListener.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.gui.event;

import adams.gui.core.BaseTabbedPaneWithTabHiding;

/**
 * Interface for classes that listen to changes in visibility of tabs
 * of a {@link BaseTabbedPaneWithTabHiding}.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3934 $
 * @see BaseTabbedPaneWithTabHiding
 */
public interface TabVisibilityChangeListener {

  /**
   * Gets called when a tab changes visibility.
   *
   * @param e		the trigger event
   */
  public void tabVisibilityChanged(TabVisibilityChangeEvent e);
}
