/**
 * ArrayConsumerTest.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.core.option;

import adams.core.base.BaseString;
import adams.core.io.PlaceholderFile;
import adams.flow.core.AbstractActor;

/**
 * Tests the ArrayConsumer class.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 2819 $
 */
public class ArrayConsumerTest
  extends AbstractOptionConsumerTestCase<String[]> {

  /**
   * Initializes the test.
   *
   * @param name	the name of the test
   */
  public ArrayConsumerTest(String name) {
    super(name);
  }

  /**
   * Tests a simple option handler.
   */
  public void testConsumeSimple() {
    adams.flow.sink.DumpFile handler = new adams.flow.sink.DumpFile();
    handler.setDebugLevel(1);
    handler.setOutputFile(new PlaceholderFile("${TMP}/dumpfile.csv"));
    handler.setAppend(true);

    performInputTest(
	new ArrayConsumer(),
	new String[]{
	  "adams.flow.sink.DumpFile",
	  "-D",
	  "1",
	  "-output",
	  "${TMP}/dumpfile.csv",
	  "-append"
	},
	handler);
  }

  /**
   * Tests generating a simple option handler from a string.
   */
  public void testFromStringSimple() {
    adams.flow.sink.DumpFile handler = new adams.flow.sink.DumpFile();
    handler.setDebugLevel(1);
    handler.setOutputFile(new PlaceholderFile("${TMP}/dumpfile.csv"));
    handler.setAppend(true);

    performFromStringTest(
	ArrayConsumer.class,
	"adams.flow.sink.DumpFile -D 1 -output ${TMP}/dumpfile.csv -append",
	handler);
  }

  /**
   * Tests a deeply nested option handler.
   */
  public void testConsumeDeep() {
    adams.data.filter.MultiFilter handler = new adams.data.filter.MultiFilter();
    handler.setDebugLevel(1);
    adams.data.filter.AbstractFilter[] filters = new adams.data.filter.AbstractFilter[2];
    filters[0] = new adams.data.filter.PassThrough();
    filters[0].setDebugLevel(2);
    filters[1] = new adams.data.filter.MultiFilter();
    filters[1].setDebugLevel(3);
    handler.setSubFilters(filters);

    performInputTest(
	new ArrayConsumer(),
	new String[]{
	  "adams.data.filter.MultiFilter",
	  "-D",
	  "1",
	  "-filter",
	  "adams.data.filter.PassThrough -D 2",
	  "-filter",
	  "adams.data.filter.MultiFilter -D 3 -filter adams.data.filter.PassThrough"
	},
	handler);
  }

  /**
   * Tests generating a deeply nested option handler from a string.
   */
  public void testFromStringDeep() {
    adams.data.filter.MultiFilter handler = new adams.data.filter.MultiFilter();
    handler.setDebugLevel(1);
    adams.data.filter.AbstractFilter[] filters = new adams.data.filter.AbstractFilter[2];
    filters[0] = new adams.data.filter.PassThrough();
    filters[0].setDebugLevel(2);
    filters[1] = new adams.data.filter.MultiFilter();
    filters[1].setDebugLevel(3);
    handler.setSubFilters(filters);

    performFromStringTest(
	ArrayConsumer.class,
	"adams.data.filter.MultiFilter -D 1 -filter \"adams.data.filter.PassThrough -D 2\" -filter \"adams.data.filter.MultiFilter -D 3 -filter adams.data.filter.PassThrough\"",
	handler);
  }

  /**
   * Tests another deeply nested option handler.
   */
  public void testConsumeDeep2() {
    adams.data.filter.BaselineCorrection handler = new adams.data.filter.BaselineCorrection();
    adams.data.baseline.SlidingWindow baseline = new adams.data.baseline.SlidingWindow();
    baseline.setDebugLevel(2);
    handler.setBaselineCorrection(baseline);

    performInputTest(
	new ArrayConsumer(),
	new String[]{
	  "adams.data.filter.BaselineCorrection",
	  "-baseline",
	  "adams.data.baseline.SlidingWindow -D 2 -baseline adams.data.baseline.PassThrough"
	},
	handler);
  }

  /**
   * Tests generating another deeply nested option handler from a string.
   */
  public void testFromStringDeep2() {
    adams.data.filter.BaselineCorrection handler = new adams.data.filter.BaselineCorrection();
    adams.data.baseline.SlidingWindow baseline = new adams.data.baseline.SlidingWindow();
    baseline.setDebugLevel(2);
    handler.setBaselineCorrection(baseline);

    performFromStringTest(
	ArrayConsumer.class,
	"adams.data.filter.BaselineCorrection -baseline \"adams.data.baseline.SlidingWindow -D 2 -baseline adams.data.baseline.PassThrough\"",
	handler);
  }

  /**
   * Tests generating another deeply nested option handler from a string.
   */
  public void testFromStringDeep3() {
    adams.flow.control.Flow handler = new adams.flow.control.Flow();
    adams.flow.source.StringConstants sc = new adams.flow.source.StringConstants();
    sc.setStrings(new BaseString[]{
	new BaseString("1"),
	new BaseString("2"),
	new BaseString("3")
    });
    adams.data.conversion.StringToDouble s2d = new adams.data.conversion.StringToDouble();
    adams.flow.transformer.Convert con = new adams.flow.transformer.Convert();
    con.setConversion(s2d);
    adams.flow.transformer.MathExpression me = new adams.flow.transformer.MathExpression();
    me.setExpression("X^2");
    adams.flow.sink.DumpFile df = new adams.flow.sink.DumpFile();
    df.setAppend(true);
    df.setOutputFile(new PlaceholderFile("${TMP}/dumpfile.txt"));
    handler.setActors(new AbstractActor[]{
	sc,
	con,
	me,
	df
    });

    performFromStringTest(
	ArrayConsumer.class,
	"adams.flow.control.Flow -actor \"adams.flow.source.StringConstants -string 1 -string 2 -string 3\" -actor \"adams.flow.transformer.Convert -conversion adams.data.conversion.StringToDouble\" -actor \"adams.flow.transformer.MathExpression -expression X^2\" -actor \"adams.flow.sink.DumpFile -output ${TMP}/dumpfile.txt -append\"",
	handler);
  }
}
