/**
 * FlowStructureDotProducerTest.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.core.option;

import adams.core.Utils;
import adams.core.io.PlaceholderFile;
import adams.core.option.FlowStructureDotProducer;
import adams.core.option.AbstractArgumentOption;
import adams.flow.control.Flow;

/**
 * Tests the FlowStructureDotProducer class.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3503 $
 */
public class FlowStructureDotProducerTest
  extends AbstractOptionProducerTestCase {

  /**
   * Initializes the test.
   *
   * @param name	the name of the test
   */
  public FlowStructureDotProducerTest(String name) {
    super(name);
  }

  /**
   * Tests a simple option handler.
   */
  public void testSimple() {
    adams.flow.sink.DumpFile handler = new adams.flow.sink.DumpFile();
    handler.setDebugLevel(1);
    handler.setOutputFile(new PlaceholderFile("${TMP}/dumpfile.csv"));
    handler.setAppend(true);

    FlowStructureDotProducer producer = new FlowStructureDotProducer();
    producer.produce(handler);

    assertEquals(
	"getOutput() differs",
	  "digraph adams_flow_sink_DumpFile {\n"
	+ "  N1 [label=\"DumpFile\" shape=box]\n"
	+ "}\n",
	"" + producer.getOutput());
    assertEquals(
	"toString() differs",
	"" + producer.getOutput(),
	producer.toString());
  }

  /**
   * Tests a complex setup.
   */
  public void testComplex() {
    AbstractArgumentOption    argOption;

    Flow flow = new Flow();

    try {
      argOption = (AbstractArgumentOption) flow.getOptionManager().findByProperty("actors");
      adams.flow.core.AbstractActor[] tmp1 = new adams.flow.core.AbstractActor[4];
      adams.flow.source.SingleFileSupplier tmp2 = new adams.flow.source.SingleFileSupplier();
      argOption = (AbstractArgumentOption) tmp2.getOptionManager().findByProperty("file");
      tmp2.setFile((adams.core.io.PlaceholderFile) argOption.valueOf("${CWD}/parsers.xml"));

      tmp1[0] = tmp2;
      adams.flow.transformer.TextFileReader tmp4 = new adams.flow.transformer.TextFileReader();
      argOption = (AbstractArgumentOption) tmp4.getOptionManager().findByProperty("outputType");
      tmp4.setOutputType((adams.flow.transformer.TextFileReader.OutputType) argOption.valueOf("SINGLE_STRING"));

      tmp1[1] = tmp4;
      adams.flow.control.Tee tmp6 = new adams.flow.control.Tee();
      argOption = (AbstractArgumentOption) tmp6.getOptionManager().findByProperty("actors");
      adams.flow.core.AbstractActor[] tmp7 = new adams.flow.core.AbstractActor[2];
      adams.flow.transformer.Convert tmp8 = new adams.flow.transformer.Convert();
      argOption = (AbstractArgumentOption) tmp8.getOptionManager().findByProperty("conversion");
      adams.data.conversion.LowerCase tmp10 = new adams.data.conversion.LowerCase();
      tmp8.setConversion(tmp10);

      tmp7[0] = tmp8;
      adams.flow.sink.Null tmp11 = new adams.flow.sink.Null();
      tmp7[1] = tmp11;
      tmp6.setActors(tmp7);

      tmp1[2] = tmp6;
      adams.flow.sink.Display tmp12 = new adams.flow.sink.Display();
      tmp1[3] = tmp12;
      flow.setActors(tmp1);
    }
    catch (Exception e) {
      fail("Set up of flow failed: " + e);
    }

    FlowStructureDotProducer producer = new FlowStructureDotProducer();
    producer.produce(flow);

    assertEquals(
	"getOutput() differs",
	  "digraph adams_flow_control_Flow {\n"
	+ "  N1 [label=\"Flow\" shape=ellipse]\n"
	+ "  N1 -> N2\n"
	+ "  N2 [label=\"SingleFileSupplier\" shape=parallelogram]\n"
	+ "  N2 -> N3\n"
	+ "  N3 [label=\"TextFileReader\" shape=box]\n"
	+ "  N3 -> N4\n"
	+ "  N4 [label=\"Tee\" shape=triangle]\n"
	+ "  N4 -> N5\n"
	+ "  N5 [label=\"Convert\" shape=box]\n"
	+ "  N5 -> N6\n"
	+ "  N6 [label=\"Null\" shape=box]\n"
	+ "  N4 -> N7\n"
	+ "  N7 [label=\"Display\" shape=box]\n"
	+ "}\n",
	"" + producer.getOutput());
    assertEquals(
	"toString() differs",
	"" + producer.getOutput(),
	producer.toString());
  }
}
