/**
 * CommandlineToAnyTest.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */

package adams.data.conversion;

import adams.core.base.BaseText;
import adams.core.option.OptionUtils;
import adams.data.conversion.CommandlineToAny;
import adams.test.TmpFile;

import java.io.File;

/**
 * Tests the CommandlineToAny conversion.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 2879 $
 */
public class CommandlineToAnyTest
  extends AbstractConversionTestCase {

  /**
   * Constructs the test case. Called by subclasses.
   *
   * @param name 	the name of the test
   */
  public CommandlineToAnyTest(String name) {
    super(name);
  }

  /**
   * Returns the input data to use in the regression test.
   *
   * @return		the objects
   */
  protected Object[] getRegressionInput() {
    String[]	result;
    Object	obj;

    result = new String[2];

    obj       = new adams.data.filter.PassThrough();
    ((adams.data.filter.PassThrough) obj).setDebugLevel(3);
    result[0] = OptionUtils.getCommandLine(obj);

    obj       = new adams.data.filter.BaselineCorrection();
    result[1] = OptionUtils.getCommandLine(obj);

    return result;
  }

  /**
   * Returns the setups to use in the regression test.
   *
   * @return		the setups
   */
  protected AbstractConversion[] getRegressionSetups() {
    return new AbstractConversion[]{new CommandlineToAny()};
  }

  /**
   * Returns the ignored line indices to use in the regression test.
   *
   * @return		the setups
   */
  protected int[] getRegressionIgnoredLineIndices() {
    return new int[0];
  }
}
