/*
 * Decompiled with CFR 0.152.
 */
package adams.core.option;

import adams.core.Utils;
import adams.core.option.AbstractOptionConsumer;
import adams.core.option.OptionHandler;
import adams.test.AdamsTestCase;
import java.util.List;

public abstract class AbstractOptionConsumerTestCase<C>
extends AdamsTestCase {
    protected boolean m_FailOnWarnings;
    protected boolean m_FailOnErrors;

    public AbstractOptionConsumerTestCase(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.m_FailOnWarnings = true;
        this.m_FailOnErrors = true;
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void performFromStringTest(Class consumer, String s, OptionHandler handler) {
        OptionHandler created = AbstractOptionConsumer.fromString((Class)consumer, (String)s);
        AbstractOptionConsumerTestCase.assertEquals((String)"objects differ", (Object)handler, (Object)created);
    }

    public void performInputTest(AbstractOptionConsumer consumer, C input, OptionHandler handler) {
        consumer.setInput(input);
        consumer.consume();
        if (this.m_FailOnWarnings && consumer.hasWarnings()) {
            AbstractOptionConsumerTestCase.fail((String)("warnings encountered: " + Utils.flatten((List)consumer.getWarnings(), (String)", ")));
        }
        if (this.m_FailOnErrors && consumer.hasErrors()) {
            AbstractOptionConsumerTestCase.fail((String)("errors encountered: " + Utils.flatten((List)consumer.getErrors(), (String)", ")));
        }
        AbstractOptionConsumerTestCase.assertEquals((String)"objects differ", (Object)handler, (Object)consumer.getOutput());
        consumer.cleanUp();
    }
}

