/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.base.BaseString;
import adams.core.io.PlaceholderFile;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.sink.LogDumper;
import adams.flow.source.StringConstants;
import adams.flow.transformer.MakeLogEntry;
import adams.test.TmpFile;
import junit.framework.Test;
import junit.framework.TestSuite;

public class LogDumperTest
extends AbstractFlowTest {
    public LogDumperTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.deleteFileFromTmp("dumpfile.log");
    }

    @Override
    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("dumpfile.log");
        super.tearDown();
    }

    @Override
    public AbstractActor getActor() {
        StringConstants sc = new StringConstants();
        sc.setStrings(new BaseString[]{new BaseString("1.0"), new BaseString("-1.0"), new BaseString("3.1415"), new BaseString("-1.4E3"), new BaseString("1.4E-3")});
        MakeLogEntry mle = new MakeLogEntry();
        mle.setLogSource("JUnit");
        mle.setLogType("Regression test");
        LogDumper ld = new LogDumper();
        ld.setOutputFile((PlaceholderFile)new TmpFile("dumpfile.log"));
        Flow flow = new Flow();
        flow.setActors(new AbstractActor[]{sc, mle, ld});
        return flow;
    }

    public static Test suite() {
        return new TestSuite(LogDumperTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        LogDumperTest.runTest(LogDumperTest.suite());
    }
}

