/*
 * BaseDouble.java
 * Copyright (C) 2009 University of Waikato, Hamilton, New Zealand
 */

package adams.core.base;

/**
 * Wrapper for a Double object to be editable in the GOE.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 501 $
 */
public class BaseDouble
  extends BaseObject {

  /** for serialization. */
  private static final long serialVersionUID = 2527493071384732090L;

  /**
   * Initializes the string with length 0.
   */
  public BaseDouble() {
    this("0.0");
  }

  /**
   * Initializes the object with the string to parse.
   *
   * @param s		the string to parse
   */
  public BaseDouble(String s) {
    super(s);
  }

  /**
   * Checks whether the string value is a valid presentation for this class.
   *
   * @param value	the string value to check
   * @return		always true
   */
  public boolean isValid(String value) {
    try {
      Double.parseDouble(value);
      return true;
    }
    catch (Exception e) {
      return false;
    }
  }

  /**
   * Sets the string value.
   *
   * @param value	the string value
   */
  public void setValue(String value) {
    if (!isValid(value))
      return;

    try {
      m_Internal = Double.parseDouble(value);
    }
    catch (Exception e) {
      e.printStackTrace();
      m_Internal = new Double(0.0);
    }
  }

  /**
   * Returns the current string value.
   *
   * @return		the string value
   */
  public String getValue() {
    return ((Double) m_Internal).toString();
  }

  /**
   * Returns the double value.
   *
   * @return		the double value
   */
  public double doubleValue() {
    return ((Double) m_Internal).doubleValue();
  }

  /**
   * Returns a tool tip for the GUI editor (ignored if null is returned).
   *
   * @return		the tool tip
   */
  public String getTipText() {
    return "A floating point number (from " + -Double.MAX_VALUE + " to " + Double.MAX_VALUE + ").";
  }
}
