/*
 * BaseURL.java
 * Copyright (C) 2010 University of Waikato, Hamilton, New Zealand
 */

package adams.core.base;

import java.net.URL;

/**
 * Wrapper for an URL object to be editable in the GOE.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 1469 $
 */
public class BaseURL
  extends BaseObject {

  /** for serialization. */
  private static final long serialVersionUID = 4461135181234402629L;

  /** the default URL. */
  public final static String DEFAULT_URL = "http://localhost";

  /** the current URL. */
  protected URL m_Current;

  /**
   * Initializes the string with DEFAULT_URL.
   *
   * @see		#DEFAULT_URL
   */
  public BaseURL() {
    this(DEFAULT_URL);
  }

  /**
   * Initializes the object with the string to parse.
   *
   * @param s		the string to parse
   */
  public BaseURL(String s) {
    super(s);
  }

  /**
   * Checks whether the string value is a valid presentation for this class.
   *
   * @param value	the string value to check
   * @return		always true
   */
  public boolean isValid(String value) {
    try {
      new URL(value);
      return true;
    }
    catch (Exception e) {
      return false;
    }
  }

  /**
   * Sets the string value.
   *
   * @param value	the string value
   */
  public void setValue(String value) {
    if (!isValid(value))
      return;

    try {
      m_Current  = new URL(value);
      m_Internal = value;
    }
    catch (Exception e) {
      e.printStackTrace();
      m_Internal = DEFAULT_URL;
      try {
	m_Current = new URL(value);
      }
      catch (Exception ex) {
	// ignored
      }
    }
  }

  /**
   * Returns the current string value.
   *
   * @return		the string value
   */
  public String getValue() {
    return (String) m_Internal;
  }

  /**
   * Returns the URL value.
   *
   * @return		the URL value
   */
  public URL urlValue() {
    return m_Current;
  }

  /**
   * Returns a tool tip for the GUI editor (ignored if null is returned).
   *
   * @return		the tool tip
   */
  public String getTipText() {
    return "An URL (uniform resource locator).";
  }
}
