/**
 * BlacklistedOptionVisitorProducer.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.core.option;

/**
 * Interface for visitors that Allow skipping of options based on the class of
 * the return type of the properties.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 2420 $
 */
public interface BlacklistedOptionProducer {

  /**
   * Sets the classes to avoid.
   *
   * @param value	the classes
   */
  public void setBlacklisted(Class[] value);

  /**
   * Returns the blacklisted classes.
   *
   * @return		the classes
   */
  public Class[] getBlacklisted();
}
