/*
 * AbstractSimpleReportReader.java
 * Copyright (C) 2009 University of Waikato, Hamilton, New Zealand
 */

package adams.data.io.input;

import java.io.FileReader;
import java.util.Vector;

import adams.core.Properties;
import adams.data.report.Report;

/**
 * Abstract ancestor for reports to be written in properties format.
 *
 * @author FracPete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 1411 $
 * @param <T> the type of report to use
 */
public abstract class AbstractSimpleReportReader<T extends Report>
  extends AbstractReportReader<T> {

  /** for serialization. */
  private static final long serialVersionUID = -196559365684130179L;

  /** the file extensions. */
  public final static String FILE_EXTENSION = "report";

  /**
   * Returns a string describing the object.
   *
   * @return 			a description suitable for displaying in the gui
   */
  public String globalInfo() {
    return "Reads a report file in properties file format.";
  }

  /**
   * Returns a string describing the format (used in the file chooser).
   *
   * @return 			a description suitable for displaying in the
   * 				file chooser
   */
  public String getFormatDescription() {
    return "Properties file format";
  }

  /**
   * Returns the extension(s) of the format.
   *
   * @return 			the extension(s) (without the dot!)
   */
  public String[] getFormatExtensions() {
    return new String[]{FILE_EXTENSION};
  }

  /**
   * Tries to determine the parent ID for the current report.
   *
   * @param report	the report to determine the ID for
   * @return		the parent database ID, -1 if it cannot be determined
   */
  protected int determineParentID(Report report) {
    return report.getDatabaseID();
  }

  /**
   * Performs the actual reading.
   *
   * @return		the reports that were read
   */
  protected Vector<T> readData() {
    Vector<T>		result;
    Properties		props;
    FileReader		reader;

    result = new Vector<T>();

    // loads properties
    try {
      props  = new Properties();
      reader = new FileReader(m_Input.getAbsolutePath());
      props.load(reader);
      reader.close();
    }
    catch (Exception e) {
      getSystemErr().printStackTrace(e);
      props = new Properties();
    }

    // transfer properties into report
    result.add((T) Report.parseProperties(props));

    return result;
  }
}
