/*
 * AbstractLimitedConditions.java
 * Copyright (C) 2010 University of Waikato, Hamilton, New Zealand
 */

package adams.db;


/**
 * Abstract ancestor for conditions that limit the number of records retrieved.
 *
 * @author FracPete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 2391 $
 */
public abstract class AbstractLimitedConditions
  extends AbstractConditions {

  /** for serialization. */
  private static final long serialVersionUID = -8685225144623746238L;

  /** the maximum number of records. */
  protected int m_Limit;

  /**
   * Adds options to the internal list of options.
   */
  public void defineOptions() {
    super.defineOptions();

    m_OptionManager.add(
	    "limit", "limit",
	    10000, -1, null);
  }

  /**
   * Sets the maximum number of records to retrieve.
   *
   * @param value 	the limit to use
   */
  public void setLimit(int value) {
    if (value >= -1) {
      m_Limit = value;
      reset();
    }
    else {
      getSystemErr().println(
	  "The limit has to be at least -1 (unlimited), provided: " + value);
    }
  }

  /**
   * Returns the maximum number of records to retrieve.
   *
   * @return 		the limit
   */
  public int getLimit() {
    return m_Limit;
  }

  /**
   * Returns the tip text for this property.
   *
   * @return 		tip text for this property suitable for
   * 			displaying in the GUI or for listing the options.
   */
  public String limitTipText() {
    return "The maximum number of records to retrieve.";
  }
}
