/**
 * AbstractComplexElement.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.doc.docbook;

/**
 * Ancestor for elements that have nested elements.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 2504 $
 */
public abstract class AbstractComplexElement
  extends AbstractElement {

  /** for serialization. */
  private static final long serialVersionUID = -43542338015882364L;

  /**
   * Initializes the element.
   *
   * @param tag		the name of the tag
   */
  public AbstractComplexElement(String tag) {
    super(tag);
  }

  /**
   * Appends the content of the element to the buffer.
   *
   * @param buffer	the buffer to append the content to
   */
  protected void appendContent(StringBuilder buffer) {
    int				i;
    AbstractElement	child;

    for (i = 0; i < getChildCount(); i++) {
      child = (AbstractElement) getChildAt(i);
      child.toXML(buffer);
    }
  }
}
