/**
 * HomeRelocator.java
 * Copyright (C) 2010 University of Waikato, Hamilton, New Zealand
 */
package adams.env;

/**
 * Interface for classes that can "relocate" the project's home directory.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 1672 $
 * @see	    AbstractEnvironment#setHome(String)
 */
public interface HomeRelocator {

  /**
   * Sets the new home directory to use.
   * <p/>
   * Notes: cannot contain placeholders, should be absolute.
   *
   * @param value	the directory to use
   */
  public void setHome(String value);

  /**
   * Returns the value use as new home directory.
   *
   * @return		the directory to use
   */
  public String getHome();
}
