/**
 * TriggerableEventReference.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.flow.core;

/**
 * Wrapper around the name of a triggerable event (= string).
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 4255 $
 */
public class TriggerableEventReference
  extends EventReference {

  /** for serialization. */
  private static final long serialVersionUID = 3596514589424315665L;

  /**
   * Initializes the string with length 0.
   */
  public TriggerableEventReference() {
    this("");
  }

  /**
   * Initializes the object with the string to parse.
   *
   * @param s		the string to parse
   */
  public TriggerableEventReference(String s) {
    super(s);
  }

  /**
   * Returns a tool tip for the GUI editor (ignored if null is returned).
   *
   * @return		the tool tip
   */
  public String getTipText() {
    return "The name of a triggerable event.";
  }
}
