/**
 * AbstractModifyingProcessor.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.flow.processor;

import adams.flow.core.AbstractActor;

/**
 * Ancestor for processors that potentially modify flows that they are processing.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3482 $
 */
public abstract class AbstractModifyingProcessor
  extends AbstractActorProcessor
  implements ModifyingProcessor {

  /** for serialization. */
  private static final long serialVersionUID = 589249611194517455L;

  /** whether the flow was modified. */
  protected boolean m_Modified;

  /** the modified flow. */
  protected AbstractActor m_ModifiedActor;

  /**
   * Processes the actor.
   *
   * @param actor	the actor to process
   */
  public void process(AbstractActor actor) {
    m_Modified      = false;
    m_ModifiedActor = null;

    super.process(actor);

    if (m_Modified)
      m_ModifiedActor = actor;
  }

  /**
   * Returns whether the actor was modified.
   *
   * @return		true if the actor was modified
   */
  public boolean isModified() {
    return m_Modified;
  }

  /**
   * Returns the modified actor.
   *
   * @return		the modified actor, null if not modified
   */
  public AbstractActor getModifiedActor() {
    return m_ModifiedActor;
  }
}
