/*
 * ActorPathTreeRenderer.java
 * Copyright (C) 2012 University of Waikato, Hamilton, New Zealand
 */

package adams.gui.goe.actorpathtree;

import java.util.Hashtable;

import javax.swing.Icon;

import adams.gui.core.GUIHelper;
import adams.gui.core.dotnotationtree.DotNotationRenderer;

/**
 * A specialized renderer for actor path trees.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 4259 $
 */
public class ActorPathTreeRenderer
  extends DotNotationRenderer<ActorPathNode> {

  /** for serialization. */
  private static final long serialVersionUID = -800697802084012705L;

  /** stores the classname/icon relationship. */
  protected Hashtable<String,Icon> m_Icons;

  /**
   * Initializes the members.
   */
  protected void initialize() {
    super.initialize();

    m_Icons = new Hashtable<String,Icon>();
  }

  /**
   * Tries to obtain the icon for the given object.
   *
   * @param node	the node get the icon for
   * @return		the associated icon or null if not found
   */
  protected Icon getIcon(ActorPathNode node) {
    Icon	result;
    String	classname;

    result    = null;
    classname = node.getClassname();

    if (classname != null) {
      if (m_Icons.containsKey(classname)) {
	result = m_Icons.get(classname);
      }
      else {
	try {
	  result = GUIHelper.getIcon(Class.forName(classname));
	  m_Icons.put(classname, result);
	}
	catch (Exception e) {
	  result = null;
	}
      }
    }

    return result;
  }
}