/**
 * AbstractDataContainerUpdatingScriptlet.java
 * Copyright (C) 2009 University of Waikato, Hamilton, New Zealand
 */
package adams.gui.scripting;

import java.util.HashSet;
import java.util.Vector;

import adams.data.container.DataContainer;
import adams.gui.visualization.container.Container;
import adams.gui.visualization.container.ContainerManager;
import adams.gui.visualization.container.VisibilityContainer;
import adams.gui.visualization.container.VisibilityContainerManager;

/**
 * Abstract ancestor for scriptlets that update spectra in a ChromatogramPanel.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 1073 $
 */
public abstract class AbstractDataContainerUpdatingScriptlet
  extends AbstractDataContainerPanelScriptlet {

  /** for serialization. */
  private static final long serialVersionUID = -623707457032656271L;

  /** for post-processing the containers. */
  protected AbstractDataContainerUpdatingPostProcessor m_PostProcessor;

  /**
   * For initializing the member variables.
   */
  protected void initialize() {
    super.initialize();

    if (hasOwner())
      m_PostProcessor = getOwner().getDataContainerUpdatingPostProcessor();
  }

  /**
   * Updates the DataContainers in the GUI.
   *
   * @param conts	the processed DataContainers
   * @param overlay	whether to overlay the DataContainers
   */
  protected void updateDataContainers(Vector<DataContainer> conts, boolean overlay) {
    updateDataContainers(conts, overlay, new HashSet<Integer>());
  }

  /**
   * Updates the DataContainers in the GUI.
   *
   * @param conts	the processed DataContainers
   * @param overlay	whether to overlay the DataContainers
   * @param exclude	the indices to exclude
   */
  protected void updateDataContainers(Vector<? extends DataContainer> conts, boolean overlay, HashSet<Integer> exclude) {
    ContainerManager	manager;
    int			i;
    int 		n;
    boolean[] 		visible;
    Vector<Container> 	data;

    manager = getDataContainerPanel().getContainerManager();
    visible = new boolean[manager.count()];
    for (i = 0; i < visible.length; i++)
      visible[i] = ((VisibilityContainerManager) manager).isVisible(i);

    data = new Vector<Container>();
    n    = 0;
    for (i = 0; i < visible.length; i++) {
      if (!visible[i]) {
	data.add(manager.get(i));
	((VisibilityContainer) data.lastElement()).setVisible(false);
      }
      else {
	// overlay original data?
	if (overlay) {
	  data.add(manager.get(i));
	  ((VisibilityContainer) data.lastElement()).setVisible(true);
	}
	n++;
      }
    }
    n = 0;
    for (i = 0; i < visible.length; i++) {
      if (visible[i] && !exclude.contains(i)) {
	data.add(manager.newContainer(conts.get(n)));
	n++;
      }
    }

    // update
    manager.startUpdate();
    manager.clear();
    manager.addAll(data);
    manager.finishUpdate();

    // post-process data
    if (m_PostProcessor != null)
      m_PostProcessor.postProcess(conts);
  }
}
