/**
 * RunTool.java
 * Copyright (C) 2009 University of Waikato, Hamilton, New Zealand
 */
package adams.gui.scripting;

import adams.core.option.OptionUtils;
import adams.db.DatabaseConnectionHandler;
import adams.tools.AbstractTool;

/**
 <!-- scriptlet-parameters-start -->
 * Action parameters:<br/>
 * <pre>   run-tool &lt;tool + options&gt;</pre>
 * <p/>
 <!-- scriptlet-parameters-end -->
 *
 <!-- scriptlet-description-start -->
 * Description:
 * <pre>   Runs the specified tool.</pre>
 * <p/>
 <!-- scriptlet-description-end -->
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3469 $
 */
public class RunTool
  extends AbstractScriptlet {

  /** for serialization. */
  private static final long serialVersionUID = 2954163003128167687L;

  /** the action to execute. */
  public final static String ACTION = "run-tool";

  /**
   * Returns the action string used in the command processor.
   *
   * @return		the action string
   */
  public String getAction() {
    return ACTION;
  }

  /**
   * Returns a one-line listing of the options of the action.
   *
   * @return		the options or null if none
   */
  protected String getOptionsDescription() {
    return "<tool + options>";
  }

  /**
   * Returns the full description of the action.
   *
   * @return		the full description
   */
  public String getDescription() {
    return "Runs the specified tool.";
  }

  /**
   * Processes the options.
   *
   * @param options	additional/optional options for the action
   * @return		null if no error, otherwise error message
   * @throws Exception 	if something goes wrong
   */
  public String process(String options) throws Exception {
    String[]		schemeOptions;
    String		schemeClassname;
    AbstractTool	runScheme;

    // setup tool
    schemeOptions    = OptionUtils.splitOptions(options);
    schemeClassname  = schemeOptions[0];
    schemeOptions[0] = "";
    runScheme        = AbstractTool.forName(schemeClassname, schemeOptions);
    if (runScheme instanceof DatabaseConnectionHandler)
      ((DatabaseConnectionHandler) runScheme).setDatabaseConnection(getOwner().getDatabaseConnection());

    // run matcher
    showStatus("Running...");
    runScheme.run();
    showStatus("");

    return null;
  }
}
