/**
 * AbstractMessagePanel.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.gui.tools.previewbrowser;

import java.awt.BorderLayout;

import javax.swing.JLabel;

import adams.gui.core.BasePanel;

/**
 * Allows the display of a message.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 2755 $
 */
public class MessagePanel
  extends BasePanel {

  /** for serialization. */
  private static final long serialVersionUID = -842675700403438848L;

  /** the label for displaying the message. */
  protected JLabel m_LabelMessage;

  /**
   * Initializes the widgets.
   */
  protected void initGUI() {
    super.initGUI();

    setLayout(new BorderLayout());
    m_LabelMessage = new JLabel("", JLabel.CENTER);
    add(m_LabelMessage, BorderLayout.CENTER);
  }

  /**
   * Sets the message to display.
   *
   * @param value	the message
   */
  public void setMessage(String value) {
    m_LabelMessage.setText(value);
  }

  /**
   * Returns the currently displayed message.
   *
   * @return		the message
   */
  public String getMessage() {
    return m_LabelMessage.getText();
  }
}
