/*
 * ColorContainerManager.java
 * Copyright (C) 2009 University of Waikato, Hamilton, New Zealand
 */

package adams.gui.visualization.container;

import java.awt.Color;

import adams.gui.visualization.core.AbstractColorProvider;

/**
 * Indicator interface for container managers that manage containers
 * encapsulating color as well.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 2881 $
 */
public interface ColorContainerManager {

  /**
   * Sets the color provider to use.
   *
   * @param value	the color provider
   */
  public void setColorProvider(AbstractColorProvider value);

  /**
   * Returns the color provider to use.
   *
   * @return		the color provider in use
   */
  public AbstractColorProvider getColorProvider();

  /**
   * Returns the next color in line.
   *
   * @return		the next color
   */
  public Color getNextColor();
}