/*
 * ContainerListManager.java
 * Copyright (C) 2009 University of Waikato, Hamilton, New Zealand
 */

package adams.gui.visualization.container;

/**
 * Interface for panels that manage container lists.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 952 $
 * @param <M> the type of container manager to use
 */
public interface ContainerListManager<M extends ContainerManager> {

  /**
   * Sets the manager for handling the containers.
   *
   * @param value	the manager
   */
  public void setContainerManager(M value);

  /**
   * Returns a popup menu for the table of the overlay list.
   *
   * @return		the popup menu
   */
  public M getContainerManager();
}