/**
 * DataContainer.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.gui.visualization.debug.inspectionhandler;

import java.util.Hashtable;

/**
 * Provides further insight into data containers.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3101 $
 */
public class DataContainer
  extends AbstractInspectionHandler {

  /**
   * Checks whether the handler can handle the specified object.
   *
   * @param obj		the object to check
   * @return		true if the handler can handle this type of object
   */
  public boolean handles(Object obj) {
    return (obj instanceof adams.data.container.DataContainer);
  }

  /**
   * Returns further inspection values.
   *
   * @param obj		the object to further inspect
   * @return		the named inspected values
   */
  public Hashtable<String,Object> inspect(Object obj) {
    Hashtable<String,Object>	result;

    result = new Hashtable<String,Object>();

    result.put("data points", ((adams.data.container.DataContainer) obj).toArray());

    return result;
  }
}
