/*
 * Renderer.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */

package adams.gui.visualization.debug.objecttree;

import java.awt.Component;

import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

import adams.gui.core.GUIHelper;

/**
 * A specialized renderer for the tree elements.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3101 $
 */
public class Renderer
  extends DefaultTreeCellRenderer {

  /** for serialization. */
  private static final long serialVersionUID = 8669721980782126964L;

  /** the collapsed icon. */
  protected ImageIcon m_IconCollapsed;

  /** the expanded icon. */
  protected ImageIcon m_IconExpanded;

  /** the array element icon. */
  protected ImageIcon m_IconArrayElement;

  /**
   * Initializes the renderer.
   */
  public Renderer() {
    super();

    m_IconCollapsed    = GUIHelper.getIcon("folder_closed.png");
    m_IconExpanded     = GUIHelper.getIcon("folder_open.png");
    m_IconArrayElement = GUIHelper.getIcon("brackets.gif");
  }

  /**
   * For rendering the cell.
   *
   * @param tree		the tree
   * @param value		the node
   * @param sel		whether the element is selected
   * @param expanded	whether the node is expanded
   * @param leaf		whether the node is a leaf
   * @param row		the row in the tree
   * @param hasFocus	whether the node is focused
   * @return		the rendering component
   */
  public Component getTreeCellRendererComponent(
      JTree tree, Object value, boolean sel, boolean expanded,
      boolean leaf, int row, boolean hasFocus) {

    super.getTreeCellRendererComponent(
        tree, value, sel, expanded, leaf, row, hasFocus);

    ImageIcon icon = null;
    Node node = null;
    if (value instanceof Node)
      node = (Node) value;
    if (!leaf) {
      if (expanded)
	icon = m_IconExpanded;
      else
	icon = m_IconCollapsed;
    }
    else {
      if ((node != null) && node.isArrayElement())
	icon = m_IconArrayElement;
    }
    setIcon(icon);

    return this;
  }
}