/*
 * XYSequenceContainerModel.java
 * Copyright (C) 2009 University of Waikato, Hamilton, New Zealand
 */

package adams.gui.visualization.sequence;

import adams.gui.visualization.container.ContainerListManager;
import adams.gui.visualization.container.ContainerModel;

/**
 * A model for displaying the currently loaded XY sequences.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 1606 $
 */
public class XYSequenceContainerModel
  extends ContainerModel<XYSequenceContainerManager, XYSequenceContainer> {

  /** for serialization. */
  private static final long serialVersionUID = 416771727356319476L;

  /**
   * Initializes the model.
   *
   * @param panel	the panel to obtain the data from
   */
  public XYSequenceContainerModel(ContainerListManager<XYSequenceContainerManager> panel) {
    super((panel == null) ? null : panel.getContainerManager());
  }

  /**
   * Initializes the model.
   *
   * @param manager	the manager to obtain the data from
   */
  public XYSequenceContainerModel(XYSequenceContainerManager manager) {
    super(manager);
  }

  /**
   * Initializes members.
   */
  protected void initialize() {
    super.initialize();

    m_Generator           = new XYSequenceContainerDisplayIDGenerator();
    m_ColumnNameGenerator = new XYSequenceTableColumnNameGenerator();
  }
}