/*
 * ArrayMeanAbsoluteErrorTest.java
 * Copyright (C) 2010 University of Waikato, Hamilton, New Zealand
 */

package adams.data.statistics;

import junit.framework.Test;
import junit.framework.TestSuite;
import adams.env.Environment;

/**
 * Tests the adams.data.statistics.ArrayMeanAbsoluteError class. Run from commandline with: <p/>
 * java adams.data.statistics.ArrayMeanAbsoluteErrorTest
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 2208 $
 */
public class ArrayMeanAbsoluteErrorTest
  extends AbstractArrayStatisticTestCase<ArrayMeanAbsoluteError, Number> {

  /**
   * Initializes the test.
   *
   * @param name	the name of the test
   */
  public ArrayMeanAbsoluteErrorTest(String name) {
    super(name);
  }

  /**
   * Returns the data used in the regression test.
   *
   * @return		the data
   */
  protected Number[][][] getRegressionInputData() {
    Number[][][]	result;

    result = new Number[][][]{
	{
	  {1.0, 2.0, 3.0, 4.0},
	  {1.0, 2.0, 3.0, 4.0}
	},
	{
	  {1.0, 2.0, 3.0, 4.0},
	  {4.0, 3.0, 2.0, 1.0}
	},
	{
	  {7.0, 1.0, -10.0, 4.0},
	  {4.0, 3.0, 2.0, 1.0},
	  {1.0, 2.0, 3.0, 4.0}
	}
    };

    return result;
  }

  /**
   * Returns the setups to use in the regression test.
   *
   * @return		the setups
   */
  protected ArrayMeanAbsoluteError[] getRegressionSetups() {
    ArrayMeanAbsoluteError[]	result;

    result = new ArrayMeanAbsoluteError[3];

    result[0] = new ArrayMeanAbsoluteError();
    result[1] = new ArrayMeanAbsoluteError();
    result[2] = new ArrayMeanAbsoluteError();

    return result;
  }

  /**
   * Returns a test suite.
   *
   * @return		the test suite
   */
  public static Test suite() {
    return new TestSuite(ArrayMeanAbsoluteErrorTest.class);
  }

  /**
   * Runs the test from commandline.
   *
   * @param args	ignored
   */
  public static void main(String[] args) {
    Environment.setEnvironmentClass(Environment.class);
    runTest(suite());
  }
}
