/**
 * MultiProcessorTest.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.flow.processor;

import junit.framework.Test;
import junit.framework.TestSuite;
import adams.core.base.BaseRegExp;
import adams.core.base.BaseString;
import adams.env.Environment;
import adams.flow.control.Branch;
import adams.flow.control.Flow;
import adams.flow.control.Sequence;
import adams.flow.core.AbstractActor;
import adams.flow.core.GlobalActorReference;
import adams.flow.processor.AbstractActorProcessor;
import adams.flow.processor.MultiProcessor;
import adams.flow.processor.RemoveDisabledActors;
import adams.flow.sink.Display;
import adams.flow.sink.GlobalSink;
import adams.flow.source.StringConstants;
import adams.flow.standalone.DeleteFile;
import adams.flow.standalone.GlobalActors;
import adams.flow.transformer.Convert;
import adams.test.TmpDirectory;

/**
 * Tests the MultiProcessor processor.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3507 $
 */
public class MultiProcessorTest
  extends AbstractActorProcessorTestCase {

  /**
   * Constructs the test.
   *
   * @param name 	the name of the test
   */
  public MultiProcessorTest(String name) {
    super(name);
  }

  /**
   * Used to create an instance of a specific actor.
   *
   * @return a suitably configured <code>AbstractActor</code> value
   */
  public AbstractActor getActor() {
    DeleteFile df = new DeleteFile();
    df.setDirectory(new TmpDirectory());
    df.setRegExp(new BaseRegExp("dumpfile.txt"));
    df.setSkip(true);

    Display d1 = new Display();
    d1.setName("dis");

    GlobalActors ga = new GlobalActors();
    ga.setActors(new AbstractActor[]{
	d1
    });

    StringConstants sc = new StringConstants();
    sc.setStrings(new BaseString[]{
	new BaseString("1"),
	new BaseString("2"),
	new BaseString("3"),
	new BaseString("4")
    });

    Convert con1 = new Convert();
    con1.setSkip(true);

    GlobalSink gs1 = new GlobalSink();
    gs1.setGlobalName(new GlobalActorReference("dis"));

    Sequence seq1 = new Sequence();
    seq1.setActors(new AbstractActor[]{
	con1,
	gs1
    });

    Convert con2 = new Convert();

    GlobalSink gs2 = new GlobalSink();
    gs2.setGlobalName(new GlobalActorReference("dis"));

    Sequence seq2 = new Sequence();
    seq2.setActors(new AbstractActor[]{
	con2,
	gs2
    });

    Branch br = new Branch();
    br.setBranches(new AbstractActor[]{
	seq1,
	seq2
    });

    Flow flow = new Flow();
    flow.setActors(new AbstractActor[]{
	df,
	ga,
	sc,
	br
    });

    return flow;
  }

  /**
   * Returns the setups to use in the regression test.
   *
   * @return		the setups
   */
  protected AbstractActorProcessor[] getRegressionSetups() {
    MultiProcessor[]	result;

    result    = new MultiProcessor[1];
    result[0] = new MultiProcessor();
    result[0].setSubProcessors(new AbstractActorProcessor[]{
	new RemoveDisabledActors(),
	new RemoveDisabledActors()
    });

    return result;
  }

  /**
   * Returns the test suite.
   *
   * @return		the suite
   */
  public static Test suite() {
    return new TestSuite(MultiProcessorTest.class);
  }

  /**
   * Runs the test from commandline.
   *
   * @param args	ignored
   */
  public static void main(String[] args) {
    Environment.setEnvironmentClass(Environment.class);
    runTest(suite());
  }
}
