/*
 * Decompiled with CFR 0.152.
 */
package adams.core;

import adams.core.Utils;
import adams.env.Environment;
import adams.test.AdamsTestCase;
import junit.framework.Test;
import junit.framework.TestSuite;

public class UtilsTest
extends AdamsTestCase {
    public UtilsTest(String name) {
        super(name);
    }

    public void testPadLeftNoTruncate() {
        String in = "blah";
        String out = Utils.padLeft((String)in, (char)'0', (int)10);
        UtilsTest.assertEquals((String)"Length wrong", (int)10, (int)out.length());
        UtilsTest.assertEquals((String)"Content wrong", (String)"000000blah", (String)out);
        in = "blah";
        out = Utils.padLeft((String)in, (char)'0', (int)4);
        UtilsTest.assertEquals((String)"Length wrong", (int)4, (int)out.length());
        UtilsTest.assertEquals((String)"Content wrong", (String)in, (String)out);
        in = "blah";
        out = Utils.padLeft((String)in, (char)'0', (int)3);
        UtilsTest.assertEquals((String)"Length wrong", (int)4, (int)out.length());
        UtilsTest.assertEquals((String)"Content wrong", (String)in, (String)out);
    }

    public void testPadLeftWithTruncate() {
        String in = "blah";
        String out = Utils.padLeft((String)in, (char)'0', (int)10, (boolean)true);
        UtilsTest.assertEquals((String)"Length wrong", (int)10, (int)out.length());
        UtilsTest.assertEquals((String)"Content wrong", (String)"000000blah", (String)out);
        in = "blah";
        out = Utils.padLeft((String)in, (char)'0', (int)4, (boolean)true);
        UtilsTest.assertEquals((String)"Length wrong", (int)4, (int)out.length());
        UtilsTest.assertEquals((String)"Content wrong", (String)in, (String)out);
        in = "blah";
        out = Utils.padLeft((String)in, (char)'0', (int)3, (boolean)true);
        UtilsTest.assertEquals((String)"Length wrong", (int)3, (int)out.length());
        UtilsTest.assertEquals((String)"Content wrong", (String)"lah", (String)out);
    }

    protected void performSplitTest(String in, char delim, String[] exp) {
        String[] out = Utils.split((String)in, (char)delim);
        UtilsTest.assertEquals((String)"# of cells differs", (int)exp.length, (int)out.length);
        for (int i = 0; i < exp.length; ++i) {
            UtilsTest.assertEquals((String)("cell #" + (i + 1) + " differs"), (String)exp[i], (String)out[i]);
        }
    }

    public void testSplit() {
        this.performSplitTest("hello", ',', new String[]{"hello"});
        this.performSplitTest("hello,world", ',', new String[]{"hello", "world"});
        this.performSplitTest("hello", '|', new String[]{"hello"});
        this.performSplitTest("hello|world", '|', new String[]{"hello", "world"});
        this.performSplitTest("hello,world,out,there", ',', new String[]{"hello", "world", "out", "there"});
        this.performSplitTest("hello,world,out,there", '\t', new String[]{"hello,world,out,there"});
        this.performSplitTest("hello\tworld\tout\tthere", '\t', new String[]{"hello", "world", "out", "there"});
        this.performSplitTest("hello\t\tout\tthere", '\t', new String[]{"hello", "", "out", "there"});
        this.performSplitTest("hello\t\t\t", '\t', new String[]{"hello", "", "", ""});
    }

    public void testDoubleToStringFixed() {
        UtilsTest.assertEquals((String)"output differs", (String)"1.234", (String)Utils.doubleToStringFixed((double)1.234, (int)-1));
        UtilsTest.assertEquals((String)"output differs", (String)"1", (String)Utils.doubleToStringFixed((double)1.234, (int)0));
        UtilsTest.assertEquals((String)"output differs", (String)"1.2", (String)Utils.doubleToStringFixed((double)1.234, (int)1));
        UtilsTest.assertEquals((String)"output differs", (String)"1.23", (String)Utils.doubleToStringFixed((double)1.234, (int)2));
        UtilsTest.assertEquals((String)"output differs", (String)"9.876", (String)Utils.doubleToStringFixed((double)9.876, (int)-1));
        UtilsTest.assertEquals((String)"output differs", (String)"9", (String)Utils.doubleToStringFixed((double)9.876, (int)0));
        UtilsTest.assertEquals((String)"output differs", (String)"9.8", (String)Utils.doubleToStringFixed((double)9.876, (int)1));
        UtilsTest.assertEquals((String)"output differs", (String)"9.87", (String)Utils.doubleToStringFixed((double)9.876, (int)2));
    }

    public static Test suite() {
        return new TestSuite(UtilsTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        UtilsTest.runTest(UtilsTest.suite());
    }
}

