/**
 * ThirdPartyCopyrightProcessor.java
 * Copyright (C) 2012 University of Waikato, Hamilton, New Zealand
 */
package adams.core.annotation;

/**
 * A processor that lists all classes/methods with 3rd party copyright.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 4511 $
 * @see MixedCopyright
 */
public class ThirdPartyCopyrightProcessor 
  extends AbstractCopyrightProcessor<ThirdPartyCopyright> {
  
  /**
   * Returns the annotation class to process.
   * 
   * @return		the class
   */
  protected Class getAnnotationClass() {
    return ThirdPartyCopyright.class;
  }
  
  /**
   * Returns the output file to write the information to.
   * 
   * @param prefix	the path/filename prefix
   * @return		the full path/filename
   */
  protected String getOutputFile(String prefix) {
    return prefix + "-copyright-3rdparty.txt";
  }

  /**
   * Returns the header row for the tab-separated output file.
   * 
   * @return		the header row
   */
  protected String getHeaderRow() {
    return
	  "Module"
	  + "\t"
	  + "Class"
	  + "\t"
	  + "Method"
	  + "\t"
	  + "Copyright"
	  + "\t"
	  + "Author"
	  + "\t"
	  + "License"
	  + "\t"
	  + "URL"
	  + "\t"
	  + "Note";
  }
  
  /**
   * Returns a data row for a specific annotation.
   * 
   * @param copyright	the copyright annotation to use
   * @param module	the module to use
   * @param cls		the class the annotation is located in
   * @param method	the method the annotation is located in, empty string if not applicable
   */
  protected String getDataRow(ThirdPartyCopyright copyright, String module, String cls, String method) {
    return
	  module
	  + "\t"
	  + cls
	  + "\t"
	  + method
	  + "\t"
	  + copyright.copyright()
	  + "\t"
	  + copyright.author()
	  + "\t"
	  + copyright.license()
	  + "\t"
	  + copyright.url()
	  + "\t"
	  + copyright.note();
  }
}