/**
 * SuffixOnlyField.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.data.report;

/**
 * Interface for fields that only have a suffix.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3507 $
 */
public interface SuffixOnlyField
  extends Comparable {

  /**
   * Checks whether the name is a compound one.
   *
   * @return		true if name is a compound one
   */
  public boolean isCompound();

  /**
   * Returns the suffix for compound fields.
   *
   * @return		the suffix, null if not compound field
   */
  public String getSuffix();
}
