/**
 * FieldProvider.java
 * Copyright (C) 2009 University of Waikato, Hamilton, New Zealand
 */
package adams.db;

import java.util.Vector;

import adams.data.report.AbstractField;
import adams.data.report.DataType;

/**
 * Interface for table classes that return Field objects.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3507 $
 * @see AbstractIndexedTable
 */
public interface FieldProvider<T extends AbstractField>
  extends DatabaseConnectionProvider {

  /**
   * Returns all available fields.
   *
   * @return		the list of fields
   */
  public Vector<T> getFields();

  /**
   * Returns all available fields.
   *
   * @param dtype	the type to limit the search to, use "null" for all
   * @return		the list of fields
   */
  public Vector<T> getFields(DataType dtype);
}
