/**
 * ActorTemplateSuggestionDefinition.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.env;

import adams.gui.flow.tree.ActorTemplateSuggestion;

/**
 * Definition for the ActorTemplateSuggestion props file.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3993 $
 */
public class ActorTemplateSuggestionDefinition
  extends AbstractPropertiesDefinition {

  /** for serialization. */
  private static final long serialVersionUID = 4240048624553812140L;

  /** the key as constant. */
  public final static String KEY = "actor template suggestion";

  /**
   * Returns the key this definition is for.
   *
   * @return		the key
   */
  public String getKey() {
    return KEY;
  }

  /**
   * Returns the properties file name (no path) this definition is for.
   *
   * @return		the key
   */
  public String getFile() {
    return ActorTemplateSuggestion.FILENAME;
  }

  /**
   * Updates the environment object with its definition for the props file
   * (whether to add/replace/etc the values).
   *
   * @param env		the environment object to update
   */
  public void update(AbstractEnvironment env) {
    add(env, Project.NAME + "/gui/flow/tree", new String[0]);
  }
}
