/**
 * Not.java
 * Copyright (C) 2012 University of Waikato, Hamilton, New Zealand
 */
package adams.flow.condition.bool;

import adams.flow.core.AbstractActor;
import adams.flow.core.Token;
import adams.flow.core.Unknown;

/**
 <!-- globalinfo-start -->
 * Negates the output of the specified condition.
 * <p/>
 <!-- globalinfo-end -->
 *
 <!-- options-start -->
 * Valid options are: <p/>
 * 
 * <pre>-D &lt;int&gt; (property: debugLevel)
 * &nbsp;&nbsp;&nbsp;The greater the number the more additional info the scheme may output to 
 * &nbsp;&nbsp;&nbsp;the console (0 = off).
 * &nbsp;&nbsp;&nbsp;default: 0
 * &nbsp;&nbsp;&nbsp;minimum: 0
 * </pre>
 * 
 * <pre>-condition &lt;adams.flow.condition.bool.AbstractBooleanCondition&gt; (property: condition)
 * &nbsp;&nbsp;&nbsp;The condition to evaluate and negate.
 * &nbsp;&nbsp;&nbsp;default: adams.flow.condition.bool.Expression
 * </pre>
 * 
 <!-- options-end -->
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 4556 $
 */
public class Not
  extends AbstractBooleanCondition {

  /** for serialization. */
  private static final long serialVersionUID = -7927342245398106669L;

  /** the condition to evaluate and negate. */
  protected AbstractBooleanCondition m_Condition;
  
  /**
   * Returns a string describing the object.
   *
   * @return 			a description suitable for displaying in the gui
   */
  public String globalInfo() {
    return "Negates the output of the specified condition.";
  }

  /**
   * Adds options to the internal list of options.
   */
  public void defineOptions() {
    super.defineOptions();

    m_OptionManager.add(
	    "condition", "condition",
	    getDefaultCondition());
  }

  /**
   * Returns the default condition.
   *
   * @return		the default condition
   */
  protected AbstractBooleanCondition getDefaultCondition() {
    return new Expression();
  }

  /**
   * Sets the condition.
   *
   * @param value	the condition
   */
  public void setCondition(AbstractBooleanCondition value) {
    m_Condition = value;
    reset();
  }

  /**
   * Returns the current condition.
   *
   * @return		the condition
   */
  public AbstractBooleanCondition getCondition() {
    return m_Condition;
  }

  /**
   * Returns the tip text for this property.
   *
   * @return 		tip text for this property suitable for
   * 			displaying in the GUI or for listing the options.
   */
  public String conditionTipText() {
    return "The condition to evaluate and negate.";
  }

  /**
   * Returns the quick info string to be displayed in the flow editor.
   *
   * @return		the quick info
   */
  public String getQuickInfo() {
    String	result;
    
    result = m_Condition.getQuickInfo();
    if (result != null)
      return "! " + result;
    else
      return result;
  }

  /**
   * Returns the class that the consumer accepts.
   *
   * @return		Unknown
   */
  public Class[] accepts() {
    return new Class[]{Unknown.class};
  }

  /**
   * Configures the condition.
   *
   * @return		always null
   */
  public String setUp() {
    return m_Condition.setUp();
  }

  /**
   * Evaluates the condition.
   *
   * @param owner	the owning actor
   * @param token	the current token passing through the actor
   * @return		always true
   */
  protected boolean doEvaluate(AbstractActor owner, Token token) {
    return !m_Condition.evaluate(owner, token);
  }
}
