/**
 * AdditionalOptionsHandlerUtils.java
 * Copyright (C) 2010 University of Waikato, Hamilton, New Zealand
 */
package adams.flow.core;

import adams.core.option.OptionUtils;

/**
 * Utility methods for classes implementing the AdditionalOptionsHandler
 * interface.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 1164 $
 * @see AdditionalOptionsHandler
 */
public class AdditionalOptionsHandlerUtils {

  /**
   * Breaks up the option string ("key=value [key=value ...]") into key
   * value pairs and returns them in a hashtable.
   *
   * @param optStr	the option string
   * @return		the generated key=value relation
   * @throws Exception	if parsing of the options fails
   */
  public static AdditionalOptions breakUpOptions(String optStr) throws Exception {
    AdditionalOptions 	result;
    String[]		options;
    int			i;
    String		key;
    String		value;

    options = OptionUtils.splitOptions(optStr);
    result  = new AdditionalOptions();
    for (i = 0; i < options.length; i++) {
      if (options[i].indexOf("=") == -1) {
	System.err.println("Invalid option (format must be 'key=value'): " + options[i]);
	continue;
      }
      key   = options[i].substring(0, options[i].indexOf("="));
      value = options[i].substring(options[i].indexOf("=") + 1);
      result.putString(key, value);
    }

    return result;
  }

  /**
   * Sets the (additional) options, if the provided object implements the
   * AdditionalOptionsHandler interface.
   *
   * @param obj		the object to set the options for
   * @param optStr	the options string to parse and then set
   * @return		true if options could be set
   * @throws Exception	if parsing of the options failed
   * @see		AdditionalOptionsHandler
   */
  public static boolean setOptions(Object obj, String optStr) throws Exception {
    boolean	result;

    result = false;

    if (obj instanceof AdditionalOptionsHandler) {
      ((AdditionalOptionsHandler) obj).setAdditionalOptions(breakUpOptions(optStr));
      result = true;
    }

    return result;
  }
}
