/*
 * OutputProducer.java
 * Copyright (C) 2009 University of Waikato, Hamilton, New Zealand
 */

package adams.flow.core;

/**
 * Interface for flow actors that generate output.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 358 $
 */
public interface OutputProducer {

  /**
   * Returns the class of objects that it generates.
   *
   * @return		the Class of the generated tokens
   */
  public Class[] generates();

  /**
   * Returns the generated token.
   *
   * @return		the generated token
   */
  public Token output();

  /**
   * Checks whether there is pending output to be collected after
   * executing the flow item.
   * <p/>
   * The method is not allowed allowed to return "true" before the
   * actor has been executed. For actors that return an infinite
   * number of tokens, the m_Executed flag can be returned.
   *
   * @return		true if there is pending output
   */
  public boolean hasPendingOutput();
}
